/*
 * OOoMazeBuilder.java
 *
 * Created on March 6, 2003, 11:58 AM
 *
 * Copyright 2003 Danny Brewer
 * Anyone may run this code.
 * If you wish to modify or distribute this code, then
 *  you are granted a license to do so only under the terms
 *  of the Gnu Lesser General Public License.
 * See:  http://www.gnu.org/licenses/lgpl.html
 */

import java.awt.event.*;

/**
 *
 * @author  danny brewer
 */
public class OOoUnoMazeBuilder extends javax.swing.JFrame {
    
    /** Creates new form OOoMazeBuilder */
    public OOoUnoMazeBuilder() {
        initComponents();
        
        btnGenerate.addActionListener( new ActionListener() {
            public void actionPerformed( ActionEvent evt ) {
                generateMaze();
            }
        });
        
        chkGenerateSolution.addItemListener( new ItemListener() {
            public void itemStateChanged( ItemEvent evt ) {
                boolean checked = chkGenerateSolution.isSelected();
                chkSolutionVisible.setEnabled( checked );
                chkSolutionPrintable.setEnabled( checked );
            }
        });
        
    }
    
    
    protected void generateMaze() {
        MazeBuilderProgress mazeBuilder = new MazeBuilderProgress();
        
        // Get maze settings from user interface
        mazeBuilder.cellsAcross = Integer.parseInt( txtCellsAcross.getText() );
        mazeBuilder.cellsDown = Integer.parseInt( txtCellsDown.getText() );
        mazeBuilder.solutionTwistFactor = slidTwistSolution.getValue() / 100.0f;
        mazeBuilder.deadEndTwistFactor = slidTwistDeadEnd.getValue() / 100.0f;
        mazeBuilder.generateSolution = chkGenerateSolution.isSelected();
        mazeBuilder.solutionIsVisible = chkSolutionVisible.isSelected();
        mazeBuilder.solutionIsPrintable = chkSolutionPrintable.isSelected();
        mazeBuilder.numPages = Integer.parseInt( txtNumPages.getText() );
        
        // Get connection settings from user interface
        mazeBuilder.host = txtHost.getText();
        mazeBuilder.port = txtPort.getText();
        
        mazeBuilder.show();
        mazeBuilder.buildMaze();
    }
    
    
    
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jTabbedPane1 = new javax.swing.JTabbedPane();
        MazeParams = new javax.swing.JPanel();
        spacerTop = new javax.swing.JLabel();
        spacerLeft = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        txtCellsAcross = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        txtCellsDown = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        slidTwistSolution = new javax.swing.JSlider();
        jLabel4 = new javax.swing.JLabel();
        slidTwistDeadEnd = new javax.swing.JSlider();
        chkGenerateSolution = new javax.swing.JCheckBox();
        chkSolutionVisible = new javax.swing.JCheckBox();
        chkSolutionPrintable = new javax.swing.JCheckBox();
        jLabel5 = new javax.swing.JLabel();
        txtNumPages = new javax.swing.JTextField();
        spacerBottom = new javax.swing.JLabel();
        spacerRight = new javax.swing.JLabel();
        ConnectionParams = new javax.swing.JPanel();
        spacerTop1 = new javax.swing.JLabel();
        spacerLeft1 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        txtHost = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        txtPort = new javax.swing.JTextField();
        spacerBottom1 = new javax.swing.JLabel();
        spacerRight1 = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        ButtonPanel = new javax.swing.JPanel();
        btnGenerate = new javax.swing.JButton();

        setTitle("Maze Generator for OpenOffice.org");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        MazeParams.setLayout(new java.awt.GridBagLayout());

        spacerTop.setMinimumSize(new java.awt.Dimension(10, 10));
        spacerTop.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        MazeParams.add(spacerTop, gridBagConstraints);

        spacerLeft.setMinimumSize(new java.awt.Dimension(10, 10));
        spacerLeft.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        MazeParams.add(spacerLeft, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel1.setText("Number of Cells Across");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel1.add(jLabel1, gridBagConstraints);

        txtCellsAcross.setText("25");
        txtCellsAcross.setMinimumSize(new java.awt.Dimension(40, 22));
        txtCellsAcross.setPreferredSize(new java.awt.Dimension(40, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.1;
        jPanel1.add(txtCellsAcross, gridBagConstraints);

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel2.setText("Number of Cells Down");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel1.add(jLabel2, gridBagConstraints);

        txtCellsDown.setText("35");
        txtCellsDown.setMinimumSize(new java.awt.Dimension(40, 22));
        txtCellsDown.setPreferredSize(new java.awt.Dimension(40, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel1.add(txtCellsDown, gridBagConstraints);

        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel3.setText("Solution Path Twistyness");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel1.add(jLabel3, gridBagConstraints);

        slidTwistSolution.setValue(40);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel1.add(slidTwistSolution, gridBagConstraints);

        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel4.setText("Dead End Path Twistyness");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel1.add(jLabel4, gridBagConstraints);

        slidTwistDeadEnd.setValue(60);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel1.add(slidTwistDeadEnd, gridBagConstraints);

        chkGenerateSolution.setSelected(true);
        chkGenerateSolution.setText("Generate Solution");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel1.add(chkGenerateSolution, gridBagConstraints);

        chkSolutionVisible.setSelected(true);
        chkSolutionVisible.setText("Solution Layer Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel1.add(chkSolutionVisible, gridBagConstraints);

        chkSolutionPrintable.setText("Solution Layer Printable");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel1.add(chkSolutionPrintable, gridBagConstraints);

        jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel5.setText("Number Of Pages (Mazes)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel1.add(jLabel5, gridBagConstraints);

        txtNumPages.setText("3");
        txtNumPages.setMinimumSize(new java.awt.Dimension(40, 22));
        txtNumPages.setPreferredSize(new java.awt.Dimension(40, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.1;
        jPanel1.add(txtNumPages, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        MazeParams.add(jPanel1, gridBagConstraints);

        spacerBottom.setMinimumSize(new java.awt.Dimension(10, 10));
        spacerBottom.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        MazeParams.add(spacerBottom, gridBagConstraints);

        spacerRight.setMinimumSize(new java.awt.Dimension(10, 10));
        spacerRight.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        MazeParams.add(spacerRight, gridBagConstraints);

        jTabbedPane1.addTab("Maze Settings", MazeParams);

        ConnectionParams.setLayout(new java.awt.GridBagLayout());

        spacerTop1.setMinimumSize(new java.awt.Dimension(10, 10));
        spacerTop1.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        ConnectionParams.add(spacerTop1, gridBagConstraints);

        spacerLeft1.setMinimumSize(new java.awt.Dimension(10, 10));
        spacerLeft1.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        ConnectionParams.add(spacerLeft1, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel6.setText("Host");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel2.add(jLabel6, gridBagConstraints);

        txtHost.setText("localhost");
        txtHost.setMinimumSize(new java.awt.Dimension(40, 22));
        txtHost.setPreferredSize(new java.awt.Dimension(40, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.1;
        jPanel2.add(txtHost, gridBagConstraints);

        jLabel7.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel7.setText("Port");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel2.add(jLabel7, gridBagConstraints);

        txtPort.setText("8100");
        txtPort.setMinimumSize(new java.awt.Dimension(40, 22));
        txtPort.setPreferredSize(new java.awt.Dimension(40, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel2.add(txtPort, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        ConnectionParams.add(jPanel2, gridBagConstraints);

        spacerBottom1.setMinimumSize(new java.awt.Dimension(10, 10));
        spacerBottom1.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        ConnectionParams.add(spacerBottom1, gridBagConstraints);

        spacerRight1.setMinimumSize(new java.awt.Dimension(10, 10));
        spacerRight1.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        ConnectionParams.add(spacerRight1, gridBagConstraints);

        jTabbedPane1.addTab("Connection Settings", ConnectionParams);

        jPanel3.setLayout(new java.awt.GridBagLayout());

        jLabel8.setFont(new java.awt.Font("Tahoma", 0, 18));
        jLabel8.setText("Copyright (c) 2003 Danny Brewer");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel3.add(jLabel8, gridBagConstraints);

        jLabel9.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel9.setText("Build");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel3.add(jLabel9, gridBagConstraints);

        jLabel10.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel10.setText("2003-05-28-01");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        jPanel3.add(jLabel10, gridBagConstraints);

        jTabbedPane1.addTab("About", jPanel3);

        getContentPane().add(jTabbedPane1, java.awt.BorderLayout.CENTER);

        ButtonPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        btnGenerate.setText("Generate Maze");
        btnGenerate.setMaximumSize(new java.awt.Dimension(107, 30));
        btnGenerate.setPreferredSize(new java.awt.Dimension(107, 30));
        ButtonPanel.add(btnGenerate);

        getContentPane().add(ButtonPanel, java.awt.BorderLayout.SOUTH);

        pack();
    }//GEN-END:initComponents
    
    /** Exit the Application */
	private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
            System.exit(0);
	}//GEN-LAST:event_exitForm
        
        /**
         * @param args the command line arguments
         */
        public static void main(String args[]) {
            new OOoUnoMazeBuilder().show();
        }
        
        
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel spacerLeft1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JTextField txtHost;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JLabel spacerBottom;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JCheckBox chkSolutionVisible;
    private javax.swing.JButton btnGenerate;
    private javax.swing.JTextField txtNumPages;
    private javax.swing.JSlider slidTwistSolution;
    private javax.swing.JPanel ConnectionParams;
    private javax.swing.JLabel spacerRight1;
    private javax.swing.JTextField txtCellsAcross;
    private javax.swing.JLabel spacerBottom1;
    private javax.swing.JCheckBox chkGenerateSolution;
    private javax.swing.JLabel spacerLeft;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JPanel ButtonPanel;
    private javax.swing.JTextField txtPort;
    private javax.swing.JLabel spacerRight;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel spacerTop;
    private javax.swing.JCheckBox chkSolutionPrintable;
    private javax.swing.JLabel spacerTop1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel MazeParams;
    private javax.swing.JSlider slidTwistDeadEnd;
    private javax.swing.JTextField txtCellsDown;
    // End of variables declaration//GEN-END:variables
    
}
